#ifndef _PORTABLE_SOCKETS_H_
#define _PORTABLE_SOCKETS_H_

/* Common includes */
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <unistd.h>

/* Windows-specific includes and defines */
#ifdef __WINDOWS__

#include <windows.h>
#include <wincon.h>
#include <winsock2.h>
#include <ws2tcpip.h>

typedef int socklen_t;

#define ERRNO h_errno

#define SOCKET_GLOBALS \
  WSADATA WSAData; \
  WORD    wVersionRequested;

#define SOCKET_STARTUP \
  wVersionRequested = MAKEWORD(2, 2); \
  if ( WSAStartup(wVersionRequested, &WSAData) != NO_ERROR ) abort();

#define SOCKET_CLEANUP \
  WSACleanup();

/* Unix-specific includes and defines */
#else

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>

typedef int SOCKET;

#define NO_ERROR  1
#define INVALID_SOCKET -1
#define SOCKET_ERROR -1
#define SOCKADDR struct sockaddr

#define ERRNO errno

#define SOCKET_GLOBALS
#define SOCKET_STARTUP
#define SOCKET_CLEANUP

#endif

#endif
