#ifndef _RTDS_SUT_H_
#define _RTDS_SUT_H_

/* ****************************************************************************************** *
 * RequestMessageType and AnswerMessageType are used to communicate between the TTCN test
 * and the system under test.
 * 
 * mRequest and mAnswer TTCN types will be generated as a struct with one integer parameter.
 * 
 * To allow communication, types used by the system have to be the same than the ones generate
 * for the TTCN.
 * 
 * Therefore, RequestMessageType and AnswerMessageType are struct with one integer paramter
 * ****************************************************************************************** */

typedef struct _RequestMessageType
  {
  int i;
  } RequestMessageType;

typedef struct _AnswerMessageType
  {
  int i;
  } AnswerMessageType;

void handleRequestMessage(RequestMessageType * message);

void sendAnswerMessageToEnv(AnswerMessageType * message);

#endif 
