#include <stdlib.h>

#include "RTDS_BasicList.h"
#include "RTDS_MACRO.h"


// CONSTRUCTOR:
// ------------

RTDS_BasicList::RTDS_BasicList()
  {
  // Initialize attributes
  this->length = 0;
  this->firstElement = NULL;
  this->lastElement = NULL;
  }


// DESTRUCTOR:
// -----------

RTDS_BasicList::~RTDS_BasicList()
  {
  RTDS_ListAtom* atom;
  // Browse list's elements
  while ( this->firstElement != NULL )
    {
    atom = this->firstElement;
    this->firstElement = this->firstElement->cdr;
    // Free everything
    RTDS_FREE(atom);
    }
  // List is empty
  this->length = 0;
  this->lastElement = NULL;
  }


// OPERATION APPEND:
// -----------------

void RTDS_BasicList::append(void* e)
  {
  struct RTDS_ListAtom *newAtom;
  
  // Build new atom
  newAtom = (struct RTDS_ListAtom*)RTDS_MALLOC(sizeof(struct RTDS_ListAtom));
  newAtom->car = e;
  // If list is empty, insert element as first (and last) element
  if ( this->lastElement == NULL )
    {
    this->firstElement = newAtom;
    this->lastElement = newAtom;
    }
  // If list is not empty, insert new element at the end
  else
    {
    this->lastElement->cdr = newAtom;
    this->lastElement = this->lastElement->cdr;
    }
  // One more element
  this->length ++;
  }

  
// OPERATION DEL:
// --------------

void RTDS_BasicList::del(int eltIndex)
  {
  struct RTDS_ListAtom *curAtom, *prevAtom;
  int                  i = 0;
  
  // Look for element to delete
  prevAtom = NULL;
  curAtom = this->firstElement;
  while ( i < eltIndex )
    {
    prevAtom = curAtom;
    curAtom = curAtom->cdr;
    // If we got to the end of the list, index is too big => do nothing
    if ( curAtom == NULL ) return;
    i++;
    }
  // If element to delete is the first, move list's first element
  if ( prevAtom == NULL )
    {
    this->firstElement = this->firstElement->cdr;
    }
  // Otherwise, skip element to delete
  else
    {
    prevAtom->cdr = curAtom->cdr;
    }
  // If deleted element was the last one, update corresponding attribute
  if ( this->lastElement == curAtom )
    {
    this->lastElement = prevAtom;
    }
  // In all cases, free atom for deleted element
  RTDS_FREE(curAtom);
  }


// OPERATOR []:
// ------------

void*& RTDS_BasicList::operator[](int eltIndex)
  {
  struct RTDS_ListAtom *curAtom;
  int             i = 0;
  // Look for element with specified index
  curAtom = this->firstElement;
  while ( i != eltIndex )
    {
    curAtom = curAtom->cdr;
    i ++;
    }
  // Return (a reference to) the pointer associated to the atom
  return curAtom->car;
  }
