#ifndef _RTDS_LIST_H_
#define _RTDS_LIST_H_

#include "RTDS_BasicList.h"


// CLASS LIST:
// ===========
// Generic list for elements of any type

template <class Element> class RTDS_List
  {
  
  // OPERATIONS:
  // -----------
  
  public:
    // length: returns the list length
    int length()                  { return theList.length; };
    
    // append: adds an element to the list
    void append(Element* e)       { theList.append((void*)e); };
    
    // del: deletes an element from the list
    void del(int eltIndex)        { theList.del(eltIndex); };
    
    // Operator []: gets or sets an element in the list
    Element*& operator[](int i)   { return (Element*&)(theList[i]); };


  private:
    RTDS_BasicList theList;
  };

#endif
