#ifndef _RTDS_SEMAPHORE_PROCESS_H_
#define _RTDS_SEMAPHORE_PROCESS_H_


/*
** TYPE RTDS_WaitingProcessList:
** -----------------------------
** Chained list for instances waiting for a semaphore
*/

typedef struct _RTDS_WaitingProcessList
  {
  RTDS_SdlInstanceId              * sdlInstanceId;
  struct _RTDS_WaitingProcessList * next;
  } RTDS_WaitingProcessList;


/*
** TYPE RTDS_SemaphoreProcessCommon:
** ---------------------------------
** Common attributes for all semaphore types
*/

typedef struct _RTDS_SemaphoreProcessCommon
  {
  RTDS_WaitingProcessList * waiting_processes_head;
  RTDS_WaitingProcessList * waiting_processes_last;
  } RTDS_SemaphoreProcessCommon;
  

/* Initialization function for common semaphore attributes */
void RTDS_SemaphoreProcess_init(RTDS_SemaphoreProcessCommon*);

/* Functions to add, pop and remove a waiting instance on a semaphore */
void RTDS_SemaphoreProcess_addWaitingInstance(RTDS_SemaphoreProcessCommon*, RTDS_SdlInstanceId*);
short RTDS_SemaphoreProcess_popFirstWaitingInstance(RTDS_SemaphoreProcessCommon*, RTDS_SdlInstanceId**);
short RTDS_SemaphoreProcess_removeWaitingInstance(RTDS_SemaphoreProcessCommon*, RTDS_SdlInstanceId*);

#endif
