/* PragmaDev RTDS Embos integration */

/* List of errors returned by RTDS 'kernel' */

#define RTDS_ERROR_NO_MORE_TIMER_UNIQUE_ID                           0x0001
#define RTDS_ERROR_MSG_Q_SEND_IN_WATCHDOG                            0x0002
#define RTDS_ERROR_DELETE_WATCHDOG                                   0x0003
#define RTDS_ERROR_WATCHDOG_START                                    0x0004
#define RTDS_ERROR_DELETE_WATCHDOG_ID                                0x0005

#define RTDS_ERROR_MSG_QUEUE_SEND                                    0x0010
#define RTDS_ERROR_MSG_QUEUE_RECEIVE                                 0x0011 /* Error while trying to read the message queue */
#define RTDS_ERROR_MSG_INPUT                                         0x0012
#define RTDS_ERROR_MSG_QUEUE_DELETE                                  0x0013
#define RTDS_ERROR_GET_QUEUE_ID                                      0x0014 /* If cannot find process queue id */
#define RTDS_ERROR_MSG_QUEUE_RESET                                   0x0015 /* Cannot reset the message queue in order to discard all messages */
#define RTDS_ERROR_MSG_RECEIVE                                       0x0016

#define RTDS_ERROR_TASK_DELETE                                       0x0020
#define RTDS_ERROR_TASK_FINISH                                       0x0021
#define RTDS_ERROR_TASK_TO_DELETE_NOT_FOUND                          0x0022 /* The task to delete was not found in the globalProcessInfoList */
#define RTDS_ERROR_TASK_OPTIONS_NUMBER                               0x0023 /* The number of argument pass to created process not equal to RTDS_TASK_OPTIONS_NUMBER */

#define RTDS_ERROR_PROCESS_RESUME                                    0x0030
#define RTDS_ERROR_PROCESS_CREATE_MSG_Q_CREATE                       0x0031
#define RTDS_ERROR_PROCESS_CREATE_TASK                               0x0032

#define RTDS_ERROR_CREATE_MUTEX                                      0x0040
#define RTDS_ERROR_SEMAPHORE_DELETE                                  0x0041 /* Cannot delete semaphore */
#define RTDS_ERROR_SEMAPHORE_ID_GIVE                                 0x0042 /* Cannot release semaphore */
#define RTDS_ERROR_BAD_SEMAPHORE_TYPE                                0x0043 /* Bad type of semaphore */
#define RTDS_ERROR_MUTEX_NOT_SUPPORT_TIMEOUT                         0x0044 /* Mutex doesnt support timeout */

#define RTDS_ERROR_CREATE_CRITICAL_SECTION                           0x0050 /* Cannot initialize critical section */
#define RTDS_ERROR_CREATE_CRITICAL_SECTION_START                     0x0051 /* Cannot start critical section */
#define RTDS_ERROR_CREATE_CRITICAL_SECTION_STOP                      0x0052 /* Cannot stop critical section */
#define RTDS_ERROR_CREATE_CRITICAL_SECTION_DELETE                    0x0053 /* Cannot delete critical section */

#define RTDS_ERROR_ALLOCATE_MEMORY_NO_TASK_CONTEXT                   0x0060 /* When cannot allocate memory from a non task context */
#define RTDS_ERROR_DONT_HAVE_ENOUGH_MEMORY                           0x0062 /* When the allocation cannot performed from a non task context */
#define RTDS_ERROR_DEALLOCATE_MEMORY                                 0x0063 /* When cannot deallocate memory */
#define RTDS_ERROR_NO_MORE_STACK                                     0x0064 /* When create more than specified number of instances */

#define RTDS_ERROR_NO_MORE_MSG_UNIQUE_ID                             0x0070 /* No more message unique id available. Increase RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE */

#define RTDS_ERROR_CANCEL_TIMER                                      0x0080
