#include <stdlib.h>
#include <string.h>

#include "RTDS_CountingSemaphoreProcess.h"
#include "RTDS_Common.h"
#include "RTDS_InternalConstants.h"


RTDS_CountingSemaphoreProcess::RTDS_CountingSemaphoreProcess(RTDS_Scheduler *parentScheduler): RTDS_SemaphoreProcess(parentScheduler)
  {
  availableSlots = 0;
  }

short RTDS_CountingSemaphoreProcess::isAvailable() 
  {
  return availableSlots > 0;
  }

short RTDS_CountingSemaphoreProcess::RTDS_continuousSignals(int *lowestPriority) 
  {
  return 0;
  }

short RTDS_CountingSemaphoreProcess::RTDS_executeTransition(RTDS_MessageHeader *currentMessage)
  {
  static RTDS_SdlInstanceId waiterId;
  memset(&waiterId, 0, sizeof(RTDS_SdlInstanceId));
  // Remember previous state
  RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
  // Remember message as current one
  RTDS_currentContext->currentMessage = currentMessage;
  // Standard double-switch for all other messages
  if (RTDS_currentContext->currentMessage != NULL)
    {
    RTDS_senderId = RTDS_currentContext->currentMessage->sender;
    switch (RTDS_currentContext->currentMessage->messageNumber)
      {
      // Take attempt
      case RTDS_message_RTDS_takeSemaphore:
        // If semaphore is not available
        if (availableSlots == 0)
          {
          // Add message sender to list of waiting processes
          pushWaitingInstance(RTDS_senderId);
          }
        // If semaphore is available
        else
          {
          // One less available slot
          --availableSlots;
          // Take succeeded
          RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSucceeded, 0, NULL, RTDS_senderId);
          }
        break;
		
      // Give
      case RTDS_message_RTDS_giveSemaphore:
        // If there are waiting processes, pop first one from the list
        waiterId = popWaitingInstance();
        if (waiterId.instanceNumber > 0)
          {
          // Send message indicating take succeeded for it
          RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSucceeded, 0, NULL, waiterId);
          }
        // If no instance waiting for semaphore
        else
          {
          // One more available slot
          ++availableSlots;
          }
        break;
		
      // Take cancel
      case RTDS_message_RTDS_cancelTake:
        // Remove message sender from list of instances waiting for semaphore
        removeWaitingInstance(RTDS_senderId);
        break;
      }
    free(RTDS_currentContext->currentMessage);
    RTDS_currentContext->currentMessage = NULL;
    }
  return 0;
  }
