#define __STDC_FORMAT_MACROS
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>

#include "RTDS_Proc.h"
#include "RTDS_Scheduler.h"
#include "RTDS_Deployment.h"
#include "RTDS_Common.h"
#include "RTDS_InternalConstants.h"
#include "RTDS_OS.h"
#include "RTDS_gen.h"


RTDS_Proc::RTDS_Proc(RTDS_Scheduler *parentScheduler)
  {
  RTDS_parentScheduler = parentScheduler;
  RTDS_currentContext = NULL;
  RTDS_calledProcedure = NULL;
  RTDS_initialMessage = NULL;
  RTDS_sdlStatePrev = 0;
  RTDS_nextLabelId = 0;
  RTDS_isProcedure = 0;
  }

RTDS_Proc::~RTDS_Proc() 
  {
  // Delete called procedure if any
  if (RTDS_calledProcedure != NULL)
    {
    delete RTDS_calledProcedure;
    }
  // Delete message that triggered last executed transition if needed
  if (RTDS_initialMessage != NULL && RTDS_initialMessage != RTDS_currentContext->currentMessage)
    {
    if (RTDS_initialMessage->pData != NULL)
      {
      free(RTDS_initialMessage->pData);
      }
    free(RTDS_initialMessage);
    }
  // If instance is a process, delete its context
  if (RTDS_isProcedure == 0)
    {
    // Delete current message
    if (RTDS_currentContext->currentMessage != NULL)
      {
      if (RTDS_currentContext->currentMessage->pData != NULL)
        {
        free(RTDS_currentContext->currentMessage->pData);
        }
      free(RTDS_currentContext->currentMessage);
      }
    // Clean save queue
    while (RTDS_currentContext->readSaveQueue != NULL)
      {
      RTDS_MessageHeader *message = RTDS_currentContext->readSaveQueue;
      RTDS_currentContext->readSaveQueue = RTDS_currentContext->readSaveQueue->next;
      if (message->pData != NULL)
        {
        free(message->pData);
        }
      free(message);
      }
    // Delete context
    free(RTDS_currentContext);
    }
  }

void RTDS_Proc::RTDS_msgQueueSendToId(int messageNumber, long dataLength, unsigned char *pData, RTDS_SdlInstanceId &receiver) 
  {
  RTDS_parentScheduler->sendMessage(RTDS_currentContext->mySdlInstanceId, receiver, messageNumber, dataLength, pData);
  // Trace semaphore operations
  if (messageNumber == RTDS_message_RTDS_takeSucceeded) 
    {
    fprintf(RTDS_traceFile, "    <takeSucceeded nId=\"n%u\" cId=\"c%u\" time=\"%"PRId64"\" pName=\"p%d\" semName=\"x%d\" stillAvailable=\"%d\" pId=\"%u\" semId=\"%u\" />\n", \
      RTDS_parentScheduler->component->node->nodeUniqueId,
      RTDS_parentScheduler->component->componentUniqueId,
      RTDS_TickGet(), 
      receiver.processNumber, 
      -RTDS_currentContext->mySdlInstanceId.processNumber, 
      ((RTDS_SemaphoreProcess *) this)->isAvailable(), 
      receiver.instanceNumber, 
      RTDS_currentContext->mySdlInstanceId.instanceNumber
    );
    } 
  else if (messageNumber == RTDS_message_RTDS_cancelTake) 
    {
    fprintf(RTDS_traceFile, "    <takeTimedOut nId=\"n%u\" cId=\"c%u\" time=\"%"PRId64"\" pName=\"p%d\" semName=\"x%d\" pId=\"%u\" semId=\"%u\" />\n",
      RTDS_parentScheduler->component->node->nodeUniqueId, 
      RTDS_parentScheduler->component->componentUniqueId,
      RTDS_TickGet(), 
      RTDS_currentContext->mySdlInstanceId.processNumber, 
      -receiver.processNumber, 
      RTDS_currentContext->mySdlInstanceId.instanceNumber, 
      receiver.instanceNumber
    );
    } 
  else if (messageNumber == RTDS_message_RTDS_giveSemaphore) 
    {
    fprintf(RTDS_traceFile, "    <giveSem nId=\"n%u\" cId=\"c%u\" time=\"%"PRId64"\" pName=\"p%d\" semName=\"x%d\" pId=\"%u\" semId=\"%u\" />\n",
      RTDS_parentScheduler->component->node->nodeUniqueId, 
      RTDS_parentScheduler->component->componentUniqueId,
      RTDS_TickGet(), 
      RTDS_currentContext->mySdlInstanceId.processNumber, 
      -receiver.processNumber, 
      RTDS_currentContext->mySdlInstanceId.instanceNumber, 
      receiver.instanceNumber
    );
    }	
  }

void RTDS_Proc::RTDS_msgQueueSendToEnv(int messageNumber, long dataLength, unsigned char *pData) 
  {
  RTDS_SdlInstanceId &receiver = RTDS_parentScheduler->envInstance->RTDS_currentContext->mySdlInstanceId;
  RTDS_parentScheduler->sendMessage(RTDS_currentContext->mySdlInstanceId, receiver, messageNumber, dataLength, pData);
  }

void RTDS_Proc::RTDS_msgQueueSendToName(int messageNumber, long dataLength, unsigned char *pData, const char *receiverName, int receiverNumber) 
  {
  RTDS_SdlInstanceId receiver(receiverNumber);
  RTDS_parentScheduler->sendMessage(RTDS_currentContext->mySdlInstanceId, receiver, messageNumber, dataLength, pData);
  }

void RTDS_Proc::RTDS_msgSave(RTDS_MessageHeader *message)
  {
  if (RTDS_currentContext->writeSaveQueue == NULL)
    {
    RTDS_currentContext->writeSaveQueue = message;
    RTDS_currentContext->readSaveQueue = RTDS_currentContext->writeSaveQueue;
    }
  else
    {
    RTDS_currentContext->writeSaveQueue->next = message;
    RTDS_currentContext->writeSaveQueue = RTDS_currentContext->writeSaveQueue->next;
    }
  RTDS_currentContext->writeSaveQueue->next = NULL;
  // Trace (ignore semaphore and proxy)
  if (message->messageNumber > 0 && RTDS_currentContext->mySdlInstanceId.instanceNumber > 0) 
    {
		fprintf(RTDS_traceFile, "    <messageSaved nId=\"n%u\" cId=\"c%u\" time=\"%"PRId64"\" pName=\"p%d\" mId=\"%d\" pId=\"%u\" sigNum=\"%d\" msgName=\"m%d\" />\n",
      RTDS_parentScheduler->component->node->nodeUniqueId, 
      RTDS_parentScheduler->component->componentUniqueId,
      RTDS_TickGet(), 
      RTDS_currentContext->mySdlInstanceId.processNumber, 
      message->messageUniqueId, 
      RTDS_currentContext->mySdlInstanceId.instanceNumber, 
      message->messageNumber, 
      message->messageNumber
		);
		}
  }

void RTDS_Proc::RTDS_resetTimer(int timerNumber) 
  {
	RTDS_TimerStop(this, timerNumber);
  }

void RTDS_Proc::RTDS_setTimer(int timerNumber, int delay) 
  {
  RTDS_TimerStop(this, timerNumber);
	RTDS_TimerStart(this, timerNumber, delay);
  }

void RTDS_Proc::RTDS_processCreate(int processNumber) 
  {
	RTDS_currentContext->offspringSdlInstanceId = RTDS_parentScheduler->createInstance(processNumber, this);
  }

void RTDS_Proc::RTDS_setSdlState(int state) 
  {
  fprintf(RTDS_traceFile, "    <taskChangedState nId=\"n%u\" cId=\"c%u\" time=\"%"PRId64"\" pName=\"p%d\" pId=\"%u\" stateName=\"s%d\" />\n",
    RTDS_parentScheduler->component->node->nodeUniqueId,
    RTDS_parentScheduler->component->componentUniqueId,
    RTDS_TickGet(), 
    RTDS_currentContext->mySdlInstanceId.processNumber, 
    RTDS_currentContext->mySdlInstanceId.instanceNumber, 
    state
  );
  fprintf(RTDS_traceFile, "    <nodeChangedState nId=\"n%u\" cId=\"c%u\" time=\"%"PRId64"\" stateName=\"s%d\" prevStateName=\"s%d\" />\n",
    RTDS_parentScheduler->component->node->nodeUniqueId,
    RTDS_parentScheduler->component->componentUniqueId, 
    RTDS_TickGet(), 
    state, 
    RTDS_parentScheduler->component->node->sdlState
  );
  RTDS_currentContext->sdlState = state;
  RTDS_parentScheduler->component->node->sdlState = state;
  }

RTDS_SdlInstanceId &RTDS_Proc::RTDS_GetSemaphoreId(int semaphoreNumber)
  {
  static RTDS_SdlInstanceId semaphore;
  RTDS_ScheduledInstance *instance;
  for (instance = RTDS_parentScheduler->scheduledInstances; instance != NULL; instance = instance->next)
    {
    if (instance->instanceObject->RTDS_currentContext->mySdlInstanceId.processNumber == -semaphoreNumber)
      {
      semaphore = instance->instanceObject->RTDS_currentContext->mySdlInstanceId;
      }
    }
  return semaphore;
  }
