#ifndef _RTDS_PROC_H_
#define _RTDS_PROC_H_

#include "RTDS_Common.h"

class RTDS_Scheduler;

class RTDS_Proc
{
  public:
    RTDS_Scheduler          * RTDS_parentScheduler;
    RTDS_GlobalProcessInfo  * RTDS_currentContext;
    RTDS_Proc               * RTDS_calledProcedure;
    RTDS_MessageHeader      * RTDS_initialMessage;
    RTDS_SdlInstanceId        RTDS_senderId;
    unsigned int              RTDS_nextLabelId;
    int                       RTDS_sdlStatePrev;
    short                     RTDS_isProcedure;

  public:
    RTDS_Proc(RTDS_Scheduler *parentScheduler);
    virtual ~RTDS_Proc();
    virtual short RTDS_executeTransition(RTDS_MessageHeader *currentMessage) = 0;
    virtual short RTDS_continuousSignals(int *lowestPriority) = 0;
    void RTDS_msgQueueSendToId(int messageNumber, long dataLength, unsigned char *pData, RTDS_SdlInstanceId &receiver);
    void RTDS_msgQueueSendToEnv(int messageNumber, long dataLength, unsigned char *pData);
    void RTDS_msgQueueSendToName(int messageNumber, long dataLength, unsigned char *pData, const char *receiverName, int receiverNumber);
    void RTDS_msgSave(RTDS_MessageHeader *message);
    void RTDS_resetTimer(int timerNumber);
    void RTDS_setTimer(int timerNumber, int delay);
    void RTDS_processCreate(int processNumber);
    void RTDS_setSdlState(int newState);
    RTDS_SdlInstanceId &RTDS_GetSemaphoreId(int semaphoreNumber);
};

#endif
