#include "RTDS_SemaphoreTakeProcedure.h"
#include "RTDS_Common.h"
#include "RTDS_InternalConstants.h"
#include "RTDS_MACRO.h"


RTDS_SemaphoreTakeProcedure::RTDS_SemaphoreTakeProcedure(RTDS_Scheduler *parentScheduler, RTDS_SdlInstanceId &semaphoreId, int timeOut): RTDS_Proc(parentScheduler)
  {
  this->RTDS_isProcedure = 1;
  this->semaphoreId = semaphoreId;
  this->timeOut = timeOut;
	this->RTDS_return_value = 0;
	}

short RTDS_SemaphoreTakeProcedure::RTDS_continuousSignals(int *lowestPriority) 
  {
  return 0;
  }

short RTDS_SemaphoreTakeProcedure::RTDS_executeTransition(RTDS_MessageHeader *currentMessage) 
  {
  short hasReturned = 0;
  // Remember previous state
  RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
  // Remember message as current one
  RTDS_currentContext->currentMessage = currentMessage;
  // Initial transition
  if (RTDS_currentContext->currentMessage == NULL)
    {
    if (timeOut != RTDS_SEMAPHORE_TIME_OUT_FOREVER)
      {
      RTDS_setTimer(RTDS_message_RTDS_takeTimeOut, timeOut);
      }
    RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSemaphore, 0, NULL, semaphoreId);
    // Set dummy state to force state change when the procedure returns
		RTDS_currentContext->sdlState = -1;
    }
  // Switch for all other messages
  else 
    {
    RTDS_senderId = RTDS_currentContext->currentMessage->sender;
    switch (RTDS_currentContext->currentMessage->messageNumber)
      {
      // Timer time-out: take failed
      case RTDS_message_RTDS_takeTimeOut:
        RTDS_msgQueueSendToId(RTDS_message_RTDS_cancelTake, 0, NULL, semaphoreId);
        RTDS_return_value = 0;
        hasReturned = 1;
        break;
      // Take succeeded
      case RTDS_message_RTDS_takeSucceeded:
        RTDS_resetTimer(RTDS_message_RTDS_takeTimeOut);
        RTDS_return_value = 1;
        hasReturned = 1;
        break;
      // Everything else is saved
      default:
        RTDS_msgSave(RTDS_currentContext->currentMessage);
        return 0;
      }
    }
  free(RTDS_currentContext->currentMessage);
  RTDS_currentContext->currentMessage = NULL;
  return hasReturned;
  }

