#ifndef _RTDS_SEMAPHORE_TAKE_PROCEDURE_H_
#define _RTDS_SEMAPHORE_TAKE_PROCEDURE_H_

#include "RTDS_Proc.h"


/*
** PROCEDURE RTDS_SemaphoreTakeProcedure:
** --------------------------------------
** Internal procedure for semaphore take in completely scheduled system
*/

class RTDS_SemaphoreTakeProcedure: public RTDS_Proc
{
  public:
    RTDS_SdlInstanceId    semaphoreId;
    int                   timeOut;
    int                   RTDS_return_value;
    

    // Constructor
    RTDS_SemaphoreTakeProcedure(RTDS_Scheduler *parentScheduler, RTDS_SdlInstanceId &semaphoreId, int timeOut);

    // Entry point for all transitions
    short RTDS_executeTransition(RTDS_MessageHeader *currentMessage);

    // Entry point for transitions for continuous signals
    short RTDS_continuousSignals(int *lowestPriority);
};

#endif
