		/* ********************************************************************* */
		/* $(RTDS_HOME)/share/ccg/oseepsilon/bricks/RTDS_Proc_middle.c begins    */
		/* PragmaDev RTDS OSE Epsilon integration                                */

		/* Check saved messages */
		if ( RTDS_currentContext->readSaveQueue != NULL )
			{
			RTDS_currentContext->currentMessage = RTDS_currentContext->readSaveQueue;
			RTDS_currentContext->readSaveQueue = RTDS_currentContext->readSaveQueue->next;
			}
		/* If no saved messages left, get message from process's message queue */
		else
			{
			/* No need to allocate memory in OSE when receiving a signal */
			RTDS_MSG_QUEUE_READ(RTDS_currentContext->currentMessage);
			RTDS_currentContext->currentMessage->next = NULL;
			}

		/* If signal is a timer fill in the corresponding message structure */
		RTDS_prevTimer = NULL;
		for ( RTDS_timer = RTDS_currentContext->timerList ; RTDS_timer != NULL; RTDS_timer = RTDS_timer->next )
			{
			/* If the signal is in the timer list  */
			if ( RTDS_timer->timerNumber == (long) RTDS_currentContext->currentMessage->sigNo )
				{
				if ( RTDS_timer->state == RTDS_TIMER_CANCELLED )
					{
					/* Discard current message */
					free_buf((union SIGNAL **)&(RTDS_currentContext->currentMessage));
					RTDS_currentContext->currentMessage = NULL;
					}
				else
					{
					/* Allocate a new buffer because the one allocated by the time out server is too small */
					free_buf((union SIGNAL **)&(RTDS_currentContext->currentMessage));
					RTDS_currentContext->currentMessage = (RTDS_MessageHeader *)alloc(sizeof(RTDS_MessageHeader),RTDS_timer->timerNumber);
					/* Fill in the message header structure */
					RTDS_currentContext->currentMessage->messageNumber = (long) RTDS_currentContext->currentMessage->sigNo;
					RTDS_currentContext->currentMessage->timerUniqueId = (long) RTDS_timer->timerUniqueId;
					#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACE) || defined(RTDS_FORMAT_TRACE)
						RTDS_currentContext->currentMessage->messageUniqueId = (long) 0;
						RTDS_currentContext->currentMessage->dataLength = (long) 0;
						RTDS_currentContext->currentMessage->pData = (unsigned char *) NULL;
					#endif
					}
				/* Remove it from list of timers */
				if ( RTDS_prevTimer == NULL )
					{
					RTDS_currentContext->timerList = RTDS_currentContext->timerList->next;
					}
				else
					{
					RTDS_prevTimer->next = RTDS_timer->next;
					}
				RTDS_FREE(RTDS_timer);
				break;
				}
			RTDS_prevTimer = RTDS_timer;
			}

		/* Let's process the message ! */
		if ( RTDS_currentContext->currentMessage != NULL )
			{
			#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACE) || defined(RTDS_FORMAT_TRACE)
				RTDS_messageDataToString(
					&RTDS_globalPrintableParameters,
					RTDS_currentContext->currentMessage->messageNumber,
					RTDS_currentContext->currentMessage->dataLength,
					(void *)(RTDS_currentContext->currentMessage->pData),
					RTDS_PARAM_CODEC_MAX_DEPTH);
				RTDS_SIMULATOR_TRACE(RTDS_messageReceived, RTDS_currentContext->currentMessage, SELF, RTDS_currentContext);
				RTDS_FREE(RTDS_globalPrintableParameters);
				RTDS_globalPrintableParameters = NULL;
			#endif
			RTDS_senderQueueId = RTDS_currentContext->currentMessage->sender;
			RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
		/* $(RTDS_HOME)/share/ccg/oseepsilon/bricks/RTDS_Proc_middle.c ends */
		/* ************************************************************* */

