/* PragmaDev RTDS ThreadX integration */
#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_
#ifdef __cplusplus
extern "C" {
#endif

#include "stdio.h"
#include "stdlib.h"

/* ThreadX include */
#include	 "tx_api.h"

/* Include for RTDS types */
#include "RTDS_Common.h"

/*
 * GLOBAL VARIABLES:
 * -------------------
 * Pointers to global list of information on processes and semaphores
 */
extern RTDS_GlobalProcessInfo 	*RTDS_globalProcessInfo;
extern RTDS_GlobalSemaphoreInfo *RTDS_globalSemaphoreInfo;
#ifdef RTDS_SIMULATOR
extern unsigned char						*RTDS_globalMessageUniqueIdPool;
extern RTDS_GlobalTraceInfo 		RTDS_globalTraceEntry;
/* Global variable pointing to decoded parmaters */
extern char 									*RTDS_globalPrintableParameters;
#endif

extern TX_BYTE_POOL 					 RTDS_globalBytePool;

RTDS_COVERAGE_PROTO
RTDS_CRITICAL_SECTION_PROTO

/*
 * FUNCTION PROTOTYPES:
 * -------------------
 * Function defined in RTDS_OS.c used below
 */

extern long 										          RTDS_GetTimerUniqueId 		   	( RTDS_TimerState * );
extern void 								    		      RTDS_WatchDogFunction 		   	( ULONG );
extern void 									    	      RTDS_StartTimer 						      ( RTDS_QueueId , long , long , int , RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern void 									    	      RTDS_StopTimer							       ( long , RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern void 									    	      RTDS_MsgQueueSend 					     ( long , long, unsigned char *, RTDS_QueueId , RTDS_QueueId, RTDS_GlobalProcessInfo * );
extern void 									    	      RTDS_MsgQueueReceive				    ( RTDS_SdlInstanceId *, char ** , int , int );
extern RTDS_QueueId 						      RTDS_GetProcessQueueId			   ( int processNumber );
extern void 									    	      RTDS_ProcessCreate					     ( char *processName, int processNumber, void (*)(ULONG), int , RTDS_QueueId *,RTDS_QueueId , RTDS_GlobalProcessInfo * );
extern void 									    	      RTDS_ProcessKill					      	( RTDS_GlobalProcessInfo * );
extern void 										          RTDS_Sem_Delete 						      ( RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreStatus 	  	RTDS_SemaphoreIdTake			    	( RTDS_SemaphoreId , RTDS_SemaphoreTimeout, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreId 				    RTDS_GetSemaphoreId 				    ( int semaphoreNumber );
extern RTDS_GlobalSemaphoreInfo *RTDS_GetSemaphoreInfo			   ( RTDS_SemaphoreId );

extern RTDS_SemaphoreId 				    RTDS_Sem_Info_Insert			    	( int semaphoreNumber, RTDS_SemaphoreId, enum RTDS_SemaphoreType, RTDS_GlobalProcessInfo *	);
extern RTDS_SemaphoreId 				    RTDS_BinarySemaphoreCreate	 ( char *name, int semaphoreNumber, unsigned char initialState, RTDS_GlobalProcessInfo * );
extern RTDS_MutexId 						      RTDS_MutexSemaphoreCreate 	 ( char *name, int semaphoreNumber, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreId 				    RTDS_CountingSemaphoreCreate(  char *name, int semaphoreNumber, unsigned char initialCount, RTDS_GlobalProcessInfo * );
extern void 									      	    RTDS_TransitionCleanUp			   ( RTDS_GlobalProcessInfo *RTDS_currentContext, int RTDS_sdlStatePrev );
extern unsigned long						      RTDS_GetSystemTime					     ( void );
#ifdef RTDS_SIMULATOR
extern unsigned long						      RTDS_GetMessageUniqueId 		  ( void );
extern void 										          RTDS_ReleaseMessageUniqueId ( unsigned long );
extern void 										          RTDS_DummyTraceFunction 		  ( void );
extern void 										          RTDS_messageDataToString		  ( char ** buffer, long messageNumber, long dataLength, void* dataPointer, int level);
extern char 										          *RTDS_stringToMessageData 	 ( long messageNumber, long * dataLength, void ** dataPointer, char * dataString);
#endif

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_OS_H_ */
