/* PragmaDev RTDS Uitron 3 integration */
/* List of errors returned by RTDS 'kernel' */


/* SYSTEM ERROR*/
#define RTDS_ERROR_STARTUP_CONTEXT_MALLOC            0x0002 /* startup task could not allocate memory for current context */
#define RTDS_ERROR_ALLOCATING_MEMORY_POOL            0x0003 /* Could not allocate memory pool */

/* MEMORY ALLOCATION */
#define RTDS_ERROR_MALLOC                            0x1003 /* malloc return a NULL pointer */
#define RTDS_ERROR_GETBLK                            0x1005 /* Error where call get_blk in RTDS_MemAlloc */
#define RTDS_ERROR_RELBLK                            0x1006 /* Error where call rel_blk in RTDS_Free */ 

/* TIMER */
#define RTDS_ERROR_NO_MORE_TIMER_UNIQUE_ID           0x0011
#define RTDS_ERROR_MSG_Q_SEND_IN_WATCHDOG            0x0012
#define RTDS_ERROR_WATCHDOG_CREATION                 0x0013
#define RTDS_ERROR_WATCHDOG_START                    0x0014
#define RTDS_ERROR_MSG_QUEUE_SEND                    0x0015 /* Error sending message (when calling OS primitive)*/
#define RTDS_ERROR_TIMER_TO_STOP_NOT_FOUND           0x0017
#define RTDS_ERROR_TIMER_INCONSISTANT                0x0018 /* parameters in the header are not consistant with a timer message */
#define RTDS_ERROR_DEF_ALM                           0x0019 /* Error when define an alarm */ 

/* TASK */
#define RTDS_ERROR_TASK_DELETE                       0x0020
#define RTDS_ERROR_TASK_TO_DELETE_NOT_FOUND          0x0021 /* The task to delete was not found in the globalProcessInfoList */
#define RTDS_ERROR_MSG_QUEUE_DELETE                  0x0022
#define RTDS_ERROR_PROCESS_CREATE_MALLOC             0x0023
#define RTDS_ERROR_PROCESS_CREATE_MSG_Q_CREATE       0x0024
#define RTDS_ERROR_PROCESS_START_TASK                0x0025 /* Error creating task */
#define RTDS_ERROR_PROCESS_NAME_NULL                 0x0026 /* process name length null */
#define RTDS_ERROR_PROCESS_NAME_TOO_LONG             0x0027 /* process name too long */
#define RTDS_ERROR_GET_PROCESS_QUEUE_ID              0x0028 /* process name not found */
#define RTDS_ERROR_PROCESS_CREATE                    0x0029 /* Error when creating a task */
#define RTDS_ERROR_GET_TID                           0x0052 /* Error when getting task id */

/* SEMAPHORE */
#define RTDS_ERROR_SEM_INFO_INSERT_MALLOC            0x0030
#define RTDS_ERROR_SEM_INFO_INSERT                   0x0031
#define RTDS_ERROR_GET_SEMAPHORE_ID                  0x0032 /* semaphore name not found */
#define RTDS_ERROR_SEM_CREATE                        0x0035 /* Error creating semaphore*/
#define RTDS_ERROR_SEM_FLUSH                         0x0036 /* Error when flushing the semaphore */
#define RTDS_ERROR_SEM_TAKE                          0x0037 /* Error when taking the semaphore */
#define RTDS_ERROR_SEM_TAKE                          0x0037 /* Error when taking the semaphore */
#define RTDS_ERROR_SEM_DEL                           0x0038 /* Error when deleting the semaphore */
#define RTDS_ERROR_SEM_GIV                           0x0039 /* Error when giving the semaphore */

/* MESSAGE */
#define RTDS_ERROR_NO_MORE_MSG_UNIQUE_ID             0x0040 /* No more message unique id available. Increase RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE */
#define RTDS_ERROR_MSG_RECEIVE                       0x0041 /* No more message unique id available. Increase RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE */
#define RTDS_ERROR_QUEUEID                           0x0042 /* Try to send message to a not valid QueueId*/
#define RTDS_ERROR_MSG_INPUT                         0x0043
#define RTDS_ERROR_MBX_CREATE                        0x0044 /* Error when creating mailboxe */

/* ERROR RELATED TO THE BACKTRACE */
#define RTDS_ERROR_BACK_TRACE_NOT_ENOUGH_MEMORY      0x1002 /* There is not enough memory to store all the events in RAM. Reduce RTDS_BACK_TRACE_MAX_EVENT_NUM or RTDS_BACK_TRACE_MESSAGE_DATA_SIZE */

/* TIME */
#define RTDS_ERROR_GET_TIM                           0x0050 /* Error when retreive system time */
#define RTDS_ERROR_SET_TIM                           0x0051 /* Error when set system time */
