/* PragmaDev RTDS Uitron 3 integration */

/*
 * GLOBAL VARIABLES:
 * -------------------
 * Pointers to global list of information on processes and semaphores
 */


#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "RTDS_Error.h"
/* UITRON includes */
#include "uit_func.h"

/* Include for RTDS types */
#include "RTDS_Common.h"

/******************************************************************
 *        UITRON system initialization
 * -----------------------     -----------------------------------------
 * The purpose of this function is initialize system
 ******************************************************************/
void RTDS_SystemInit(void);

#ifdef CYGINT_UITRON_CONFORMANCE
 typedef struct RTDS_ecosDummyTimerParameter
    {
    long                info;
    long                cyg_Clock;
    long                cyg_funcAdd;
    long                cyg_funcParam;
    } RTDS_ecosDummyTimerParameter;
#else
/* ADD RTOS SPECIFIC STRUCTURE IF NEEDED */
#endif


/*
 * TYPE RTDS_PROCESS.ID:
 * ----------------------
 * Type for process identifier
 */
typedef ID RTDS_ProcessId;

/*
 * STRUCT RTDS_MESSAGE.HEADER:
 * ---------------------------
 * Type for a message descriptor
 */
#ifndef _RTDS_MESSAGEHEADER_DECL_
#define _RTDS_MESSAGEHEADER_DECL_

/*
 * STRUCT RTDS_GLOBAL.SEMAPHORE.INFO:
 * -------------------------------
 * Type for the list of semaphores in the system with their information
 */
typedef struct RTDS_GlobalSemaphoreInfo
    {
    RTDS_SemaphoreId                semaphoreId;    /* The semaphore address    */
    int                             semaphoreNumber;/* Semaphore number representing its name */
    struct RTDS_GlobalSemaphoreInfo *next;          /* Next semaphoreInfo */
    } RTDS_GlobalSemaphoreInfo;

#ifdef RTDS_SIMULATOR

/* Global variable pointing to decoded parmaters */
extern char *RTDS_globalPrintableParameters;

#endif /* RTDS_SIMULATOR */

/******************************************************************
 *        MEMORY POOL FUNCTIONS
 * ----------------------------------------------------------------
 *    Function used for all malloc     (RTDS_MALLOC)
 *******************************************************************/
 
void RTDS_MPoolCreate( int size );
VP RTDS_MemAlloc( int size );
void RTDS_Free( VP ptrMem );

/******************************************************************
 *        MAIN TASK
 *******************************************************************/
void RTDS_Start( void );
 
#ifdef RTDS_SIMULATOR
/******************************************************************
 *        TRACE FUNCTION
 * ----------------------------------------------------------------
 *    Function returns the current thread ID,
 *    function used for trace purpose
 *******************************************************************/
ID RTDS_GetCurrentThread( void );
#endif

/******************************************************************
 *        SEMAPHORE FUNCTIONS and TYPE DECLARATIONS
 * ----------------------------------------------------------------
 *    Function that defines Semaphore operations
 *
 *******************************************************************/

/*------------------------------
    MUTEX SEMAPHORE CREATION
 -------------------------------
 * RETURN
            Pointer on the created semaphore: SemaphoreId
 */
extern RTDS_SemId RTDS_SemMCreate();

/*------------------------------
 COUNTING SEMAPHORE CREATION
 -------------------------------
 * PARAMETERS
            opt             : integer        Semaphore attributes
            initialState    : int            SEM_EMPTY or SEM_FULL

 * RETURN
            Pointer on the created semaphore: SemaphoreId
 */
extern RTDS_SemId RTDS_SemCCreate( int opt, int initialState );

/*------------------------------
 BINARY SEMAPHORE CREATION
 -------------------------------
 * PARAMETERS
            opt             : integer        Semaphore attributes
            initialState    : int            SEM_EMPTY or SEM_FULL

 * RETURN
            Pointer on the created semaphore: SemaphoreId
 */
extern RTDS_SemId RTDS_SemBCreate( int opt, int initial_state );

/*------------------------------
         SEMAPHORE FLUSH
 -------------------------------
 * PARAMETERS
            semId_To_Flush                : RTDS_SemId        semaphore Id

 */

extern void RTDS_SemFlush( RTDS_SemId semId_To_Flush );

/*------------------------------
         SEMAPHORE DELETE
 -------------------------------
 * PARAMETERS
            semId_To_Delete             : RTDS_SemId        semaphore Id

 */
extern void RTDS_SemDelete( RTDS_SemId semId_To_Delete);


/*------------------------------
         SEMAPHORE GIVE
 -------------------------------
 * PARAMETERS
            semId_To_Give             : RTDS_SemId        semaphore Id

 */
extern void RTDS_SemGive( RTDS_SemId semId_To_Give );

/*------------------------------
         SEMAPHORE TAKE
 -------------------------------
 * PARAMETERS
         semId_To_Take             : RTDS_SemId        semaphore
         time_to_Wait               : maximum time(ms) to wait for the semaphore
        
 * RETURN
         Return status : ERROR / OK
 
 */
extern int RTDS_SemTake( RTDS_SemId SemId_To_Give, long time_to_Wait );

/******************************************************************
 *            SYSTEM FUNCTION
 * ----------------------------------------------------------------
 *******************************************************************/
extern long  RTDS_TickGet( void );
extern void  RTDS_TickSet( long timeValue );
extern int   RTDS_GetResourceId( int ressourceType );
extern int   RTDS_FindAlarmId( void );
extern void  RTDS_InitResourceId( void );
extern void  RTDS_ReleaseResourceId( int ressourceType, int ressourceIndex );

/*
 * FUNCTION PROTOTYPES:
 * -------------------
 * Function defined in RTDS_OS.c used below
 */
extern long RTDS_GetTimerUniqueId ( RTDS_TimerState * );
extern void RTDS_WatchDogFunction ( RTDS_TimerState * );

#ifdef RTDS_SIMULATOR
extern void RTDS_SimulatorMsgQueueSend( long messageNumber, long dataLength,unsigned char *pData, RTDS_SdlInstanceId * receiver, RTDS_SdlInstanceId * sender, RTDS_GlobalProcessInfo * currentContext );
#endif /* RTDS_SIMULATOR */

extern void                 RTDS_StartTimer( RTDS_SdlInstanceId * , long , long , int , RTDS_TimerState **, RTDS_GlobalProcessInfo * currentContext );
extern void                 RTDS_StopTimer( long , RTDS_TimerState **, RTDS_GlobalProcessInfo * currentContext );
extern void                 RTDS_MsgQueueSend( long , long, unsigned char *, RTDS_SdlInstanceId* , RTDS_SdlInstanceId*, RTDS_GlobalProcessInfo * currentContext );
extern void                 RTDS_MsgQueueReceive(RTDS_SdlInstanceId *  , RTDS_MessageHeader**, int , int  );
extern RTDS_SdlInstanceId *         RTDS_GetProcessQueueId( int processNumber );
extern void                 RTDS_ProcessCreate( int processNumber, void * , int ,RTDS_SdlInstanceId **, RTDS_SdlInstanceId *, short, RTDS_GlobalProcessInfo * currentContext);
extern void                 RTDS_ProcessKill(RTDS_GlobalProcessInfo *RTDS_currentContext );
extern void                 RTDS_SemaphoreIdDelete( RTDS_SemaphoreId, RTDS_GlobalProcessInfo * currentContext );
extern RTDS_SemaphoreStatus RTDS_SemaphoreIdTake( RTDS_SemaphoreId , RTDS_SemaphoreTimeout, RTDS_GlobalProcessInfo * currentContext );
extern void                 RTDS_SemaphoreIdGive( RTDS_SemaphoreId, RTDS_GlobalProcessInfo * currentContext );
extern RTDS_SemaphoreId     RTDS_GetSemaphoreId( int semaphoreNumber );
extern RTDS_SemaphoreId     RTDS_Sem_Info_Insert( int semaphoreNumber, RTDS_SemaphoreId, RTDS_GlobalProcessInfo * currentContext );
extern int                  RTDS_CheckQueueId(RTDS_SdlInstanceId * queueId);
extern void                 RTDS_TransitionCleanUp ( RTDS_GlobalProcessInfo *RTDS_currentContext, int RTDS_sdlStatePrev );
extern unsigned long        RTDS_GetSystemTime( void );


#if defined(RTDS_SIMULATOR)
extern unsigned long        RTDS_GetMessageUniqueId( void );
extern void                 RTDS_ReleaseMessageUniqueId( unsigned long );
extern void                 RTDS_messageDataToString( char ** buffer, long messageNumber, long dataLength, void* dataPointer, int level );
extern char                 *RTDS_stringToMessageData( long messageNumber, long * dataLength, void ** dataPointer, char * dataString );
extern void                 RTDS_DummyTraceFunction( void );
#endif /* RTDS_SIMULATOR */

/*
 * EXTERNAL VARIABLE:
 * -------------------
 * Global variables
 */
extern RTDS_GlobalProcessInfo   *RTDS_globalProcessInfo;
extern RTDS_GlobalSemaphoreInfo *RTDS_globalSemaphoreInfo;
#ifdef RTDS_SIMULATOR
extern RTDS_GlobalTraceInfo     RTDS_globalTraceEntry;
extern void                     *RTDS_globalMessageUniqueIdPool;
#endif

#endif /* _RTDS_OS_H_ */

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_OS_H_ */
