/**************************************************************************
*
*           Copyright 2000-2006 Mentor Graphics Corporation
*                         All Rights Reserved.
*
*           THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY
*             INFORMATION WHICH IS THE PROPERTY OF MENTOR
*             GRAPHICS CORPORATION OR ITS LICENSORS AND IS
*                      SUBJECT TO LICENSE TERMS.
*
***************************************************************************

***************************************************************************
*
* FILE NAME                                       VERSION
*
*  kernel_cfg.c                               Nucleus uiPLUS  1.7  
*
* DESCRIPTION
*
* Nucleus uiPLUS source file configurator [version 1.7] 
* Generated : 05/31/2007 09:53:35 
*
* DATA STRUCTURES
*
*  None.
*
* FUNCTIONS
*
*  uiPLUS_System_Init
*
* DEPENDENCIES
*
*  kernel.h
*  kernel_id.h
*  er_extr.h
*
**************************************************************************/

#include "uiplus/inc/kernel.h"
#include "kernel_id.h"
#if (PLUS_VERSION_COMP <= PLUS_1_14)
    #include "plus/er_extr.h"
#else
    #include "plus/inc/er_extr.h"
#endif

#define CONFIG_DATE 20070531L
#define CONFIG_TIME 953355L
UW _KERNEL_Config_Date = CONFIG_DATE;
UW _KERNEL_Config_Time = CONFIG_TIME;

#include "RTDS_OS.h"

#define STACK_SIZE 500

char __uip_tsk1_stack[STACK_SIZE];
T_CTSK __uip_tsk1_ctsk;
UIPTSK_DATA __uip_tsk1 = { TASK_MAIN, TA_HLNG|TA_ACT, TASK_MAIN, (FP)RTDS_Init, 20, STACK_SIZE, __uip_tsk1_stack };

T_CSEM __uip_sem1_csem;
UIPSEM_DATA __uip_sem1 = { ID_SEM1, TA_TFIFO, 0, 10 };

UNSIGNED __uip_dtq1_data[TSZ_DTQ(10)/sizeof(UNSIGNED)];
T_CDTQ __uip_dtq1_cdtq;
UIPDTQ_DATA __uip_dtq1 = { ID_DTQ1, TA_TPRI, 10, __uip_dtq1_data };

T_MSG* __uip_mbx1_data[TSZ_MPRIHD(10)/sizeof(T_MSG *)];
T_CMBX __uip_mbx1_cmbx;
UIPMBX_DATA __uip_mbx1 = { ID_MBX1, TA_MFIFO, 10, __uip_mbx1_data };

char __uip_mpf1_area[(MSG_PACKET + 16)*1 + 32];
T_CMPF __uip_mpf1_cmpf;
UIPMPF_DATA __uip_mpf1 = { ID_MPF1, TA_TFIFO, 1, MSG_PACKET, __uip_mpf1_area };

T_CALM __uip_alm1_calm;
UIPALM_DATA __uip_alm1 = { ID_ALM1, TA_HLNG, NULL, (FP)RTDS_SystemInit };

/*--- Kernel data ---*/
#ifndef NMI_SUPPORT
#ifdef TMAX_TSK_OBJ
_KERNEL_OBJ_LST _KERNEL_tsk_list[TMAX_TSK_OBJ];
INT _KERNEL_tsk_max = TMAX_TSK_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_tsk_list[1];
INT _KERNEL_tsk_max = 0;
#endif

#ifdef TMAX_MBX_OBJ
_KERNEL_OBJ_LST _KERNEL_mbx_list[TMAX_MBX_OBJ];
INT _KERNEL_mbx_max = TMAX_MBX_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_mbx_list[1];
INT _KERNEL_mbx_max = 0;
#endif

#ifdef TMAX_DTQ_OBJ
_KERNEL_OBJ_LST _KERNEL_dtq_list[TMAX_DTQ_OBJ];
INT _KERNEL_dtq_max = TMAX_DTQ_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_dtq_list[1];
INT _KERNEL_dtq_max = 0;
#endif

#ifdef TMAX_SEM_OBJ
_KERNEL_OBJ_LST _KERNEL_sem_list[TMAX_SEM_OBJ];
INT _KERNEL_sem_max = TMAX_SEM_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_sem_list[1];
INT _KERNEL_sem_max = 0;
#endif

#ifdef TMAX_FLG_OBJ
_KERNEL_OBJ_LST _KERNEL_flg_list[TMAX_FLG_OBJ];
INT _KERNEL_flg_max = TMAX_FLG_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_flg_list[1];
INT _KERNEL_flg_max = 0;
#endif

#ifdef TMAX_MPF_OBJ
_KERNEL_OBJ_LST _KERNEL_mpf_list[TMAX_MPF_OBJ];
INT _KERNEL_mpf_max = TMAX_MPF_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_mpf_list[1];
INT _KERNEL_mpf_max = 0;
#endif

#ifdef TMAX_MPL_OBJ
_KERNEL_OBJ_LST _KERNEL_mpl_list[TMAX_MPL_OBJ];
INT _KERNEL_mpl_max = TMAX_MPL_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_mpl_list[1];
INT _KERNEL_mpl_max = 0;
#endif

#ifdef TMAX_CYC_OBJ
_KERNEL_OBJ_LST _KERNEL_cyc_list[TMAX_CYC_OBJ];
INT _KERNEL_cyc_max = TMAX_CYC_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_cyc_list[1];
INT _KERNEL_cyc_max = 0;
#endif

#ifdef TMAX_ALM_OBJ
_KERNEL_OBJ_LST _KERNEL_alm_list[TMAX_ALM_OBJ];
INT _KERNEL_alm_max = TMAX_ALM_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_alm_list[1];
INT _KERNEL_alm_max = 0;
#endif

#ifdef TMAX_MBF_OBJ
_KERNEL_OBJ_LST _KERNEL_mbf_list[TMAX_MBF_OBJ];
INT _KERNEL_mbf_max = TMAX_MBF_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_mbf_list[1];
INT _KERNEL_mbf_max = 0;
#endif

#ifdef TMAX_MTX_OBJ
_KERNEL_OBJ_LST _KERNEL_mtx_list[TMAX_MTX_OBJ];
INT _KERNEL_mtx_max = TMAX_MTX_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_mtx_list[1];
INT _KERNEL_mtx_max = 0;
#endif

#ifdef TMAX_POR_OBJ
_KERNEL_OBJ_LST _KERNEL_por_list[TMAX_POR_OBJ];
INT _KERNEL_por_max = TMAX_POR_OBJ;
#else
_KERNEL_OBJ_LST _KERNEL_por_list[1];
INT _KERNEL_por_max = 0;
#endif
#endif /* NMI_SUPPORT */

#define TSZ_KERNEL_POOL_SIZE		50000

/*--- Kernel initialize ---*/
void Application_Initialize(VOID *first_available_memory)
{
    UIP_Initialize(first_available_memory,TSZ_KERNEL_POOL_SIZE);

    __uip_tsk1_ctsk.tskatr = __uip_tsk1.tskatr;
    __uip_tsk1_ctsk.exinf = __uip_tsk1.exinf;
    __uip_tsk1_ctsk.task = __uip_tsk1.task;
    __uip_tsk1_ctsk.itskpri = __uip_tsk1.itskpri;
    __uip_tsk1_ctsk.stksz = __uip_tsk1.stksz;
    __uip_tsk1_ctsk.stk = __uip_tsk1.stk;
    __cre_tsk(__uip_tsk1.tskid, &__uip_tsk1_ctsk);

    __uip_sem1_csem.sematr = __uip_sem1.sematr;
    __uip_sem1_csem.isemcnt = __uip_sem1.isemcnt;
    __uip_sem1_csem.maxsem = __uip_sem1.maxsem;
    __cre_sem(__uip_sem1.semid, &__uip_sem1_csem);

    __uip_dtq1_cdtq.dtqatr = __uip_dtq1.dtqatr;
    __uip_dtq1_cdtq.dtqcnt = __uip_dtq1.dtqcnt;
    __uip_dtq1_cdtq.dtq = __uip_dtq1.dtq;
    __cre_dtq(__uip_dtq1.dtqid, &__uip_dtq1_cdtq);

    __uip_mbx1_cmbx.mbxatr = __uip_mbx1.mbxatr;
    __uip_mbx1_cmbx.maxmpri = __uip_mbx1.maxmpri;
    __uip_mbx1_cmbx.mprihd = __uip_mbx1.mprihd;
    __cre_mbx(__uip_mbx1.mbxid, &__uip_mbx1_cmbx);

    __uip_mpf1_cmpf.mpfatr = __uip_mpf1.mpfatr;
    __uip_mpf1_cmpf.blkcnt = __uip_mpf1.blkcnt;
    __uip_mpf1_cmpf.blksz = __uip_mpf1.blksz;
    __uip_mpf1_cmpf.mpf = __uip_mpf1.mpf;
    __cre_mpf(__uip_mpf1.mpfid, &__uip_mpf1_cmpf);

    __uip_alm1_calm.almatr = __uip_alm1.almatr;
    __uip_alm1_calm.exinf = __uip_alm1.exinf;
    __uip_alm1_calm.almhdr = __uip_alm1.almhdr;
    __cre_alm(__uip_alm1.almid, &__uip_alm1_calm);
}
