/* PragmaDev RTDS VxWorks integration */
#ifndef _RTDS_BASICTYPES_H_
#define _RTDS_BASICTYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "stdio.h"
#include "stdlib.h"

/* VxWorks includes */
#include "msgQLib.h"    /* for Queues */
#include "wdLib.h"      /* for watchDogs */
#include "tickLib.h"
#include "taskLib.h"    /* for task creation */
#include "semLib.h"     /* for semaphore */

#define RTDS_OK                 OK
#define RTDS_ERROR              ERROR

#define RTDS_TIMER_FINISHED     2
#define RTDS_TIMER_OK           1
#define RTDS_TIMER_CANCELLED    0

/*
 * DEFINE FOR QUEUE MANIPULATION:
 * ------------------------------
 */
#define RTDS_QUEUE_MAX_MSG          20                              /* Maximum number of messages in a queue */
#define RTDS_QUEUE_MAX_MSG_LENGTH   sizeof( RTDS_MessageHeader )    /* Maximum length of messages in a queue */

/*
 * DEFINE FOR SEMAPHORE MANIPULATION:
 * ------------------------------
 */
#define RTDS_SEMAPHORE_MAX_NAME_LENGTH          20                          /* Maximum length of a semaphore name */
#define RTDS_SEMAPHORE_TIME_OUT_FOREVER         WAIT_FOREVER                /* Time out option when taking the semaphore : wait forever */
#define RTDS_SEMAPHORE_TIME_OUT_NO_WAIT         NO_WAIT                     /* Time out option when taking the semaphore : no wait */
#define RTDS_SEMAPHORE_OPTION_PRIO              SEM_Q_PRIORITY              /* Semaphore creation option: queuing based on priority */
#define RTDS_SEMAPHORE_OPTION_FIFO              SEM_Q_FIFO                  /* Semaphore creation option: queuing based on FIFO */
#define RTDS_BINARY_SEM_INITIAL_EMPTY           SEM_EMPTY                   /* Binary semaphore creation initial state: empty */
#define RTDS_BINARY_SEM_INITIAL_FULL            SEM_FULL                    /* Binary semaphore creation initial state: full */
#define RTDS_MUTEX_SEM_DELETE_SAFE              SEM_DELETE_SAFE             /* Protects a task that owns the semaphore from unexpected deletion */
#define RTDS_MUTEX_SEM_INVERSION_SAFE           SEM_INVERSION_SAFE          /* Protect the system from priority inversion */

/*
 * DEFINE FOR PROCESS CREATION:
 * ----------------------------
 */
#define RTDS_TASK_OPTIONS                           0           /* VxWorks taskSpawn options */
#define RTDS_TASK_STACK_SIZE                        5000        /* Stack size when creating a new task */
#define RTDS_DEFAULT_PROCESS_PRIORITY               150         /* If priority not defined in SDL-RT, it will be given this value */


/*
 * TYPE RTDS_QUEUE.ID:
 * ----------------------
 * Type for a message queue identifier
 */
typedef MSG_Q_ID RTDS_RtosQueueId;

/*
 * TYPE RTDS_SEMAPHORE.ID:
 * ----------------------
 * Type for a semaphore identifier
 */
typedef SEM_ID RTDS_SemaphoreId;

/*
 * TYPE RTDS_SEMAPHORE_STATUS:
 * ----------------------
 * Type for a semaphore status
 */
typedef STATUS RTDS_SemaphoreStatus;

/*
 * TYPE RTDS_SEMAPHORE_TIMEOUT:
 * ----------------------
 * Type for a semaphore timeout value
 */
typedef int RTDS_SemaphoreTimeout;

/*
 * TYPE RTDS_PROCESS_ID:
 * ----------------------
 * Type for a pid
 */
typedef int RTDS_RtosTaskId;

/*
 * TYPE RTDS_PROCESS_PRIORITY:
 * ----------------------
 * Type for process priority
 */
typedef int RTDS_ProcessPriority;

/*
 * STRUCT RTDS_TIMER.STATE:
 * ------------------------
 * Element in chained list for all active timers
 */
typedef struct RTDS_TimerState
    {
    long timerNumber;                           /* 0x00 Message number for the timer name */
    long timerUniqueId;                         /* 0x04 Timer's unique identifier among all timers */
    unsigned long timeoutValue;                 /* 0x08 System tick counter value when it will go off */
    struct RTDS_SdlInstanceId * receiverId;     /* The instance id of the receiver */
    int state;                                  /* 0x10 State for the timer (RTDS_TIMER_OK or RTDS_TIMER_CANCELLED) */
    WDOG_ID watchDogId;                         /* 0x14 Id of the VxWorks watchDog */
    struct RTDS_TimerState * next;              /* 0x18 Next timer in list */
    } RTDS_TimerState;

/*
 * STRUCT RTDS_GLOBAL.SEMAPHORE.INFO:
 * -------------------------------
 * Type for the list of semaphores in the system with their information
 * Don't invert fields !!! This would mess up the gopher script !!!
 */
typedef struct RTDS_GlobalSemaphoreInfo
    {
    RTDS_SemaphoreId semaphoreId;               /* The semaphore address */
    int semaphoreNumber;                        /* Semaphore number representing its name */
    struct RTDS_GlobalSemaphoreInfo * next;     /* Next semaphoreInfo */
    } RTDS_GlobalSemaphoreInfo;

/*
 * Additional fields in common types
 * ---------------------------------
 */
/* Message header: none */
#define RTDS_MESSAGE_HEADER_ADDITIONNAL_FIELDS

/* Process information: add priority */
#define RTDS_GLOBAL_PROCESS_INFO_ADDITIONNAL_FIELDS \
    RTDS_ProcessPriority priority; /* Priority of the process. Only used when debugging. */

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_BASICTYPES_H_ */

