/* PragmaDev RTDS VxWorks integration */
#ifndef _RTDS_ERROR_H_
#define _RTDS_ERROR_H_

#ifdef __cplusplus
extern "C" {
#endif

/* List of errors returned by RTDS 'kernel' */

#define RTDS_ERROR_WATCHDOG_START                                   0x0001 /* Cannot start a watchdog */
#define RTDS_ERROR_MSG_Q_SEND_IN_WATCHDOG                           0x0002 /* Cannot send a message in watchdog function */
#define RTDS_ERROR_WATCHDOG_CREATION                                0x0003 /* Cannot create a watchdog */
#define RTDS_ERROR_WATCHDOG_DELETE                                  0x0004 /* Cannot delete a watchdog */

#define RTDS_ERROR_MSG_QUEUE_DELETE                                 0x0010 /* Cannot delete a message queue */
#define RTDS_ERROR_MSG_QUEUE_SEND                                   0x0011 /* Cannot send a message */
#define RTDS_ERROR_MSG_INPUT                                        0x0012 /* If the receive parameter is null */
#define RTDS_ERROR_MSG_QUEUE_RECEIVE                                0x0013 /* Error while trying to read the message queue */
#define RTDS_ERROR_MSG_RECEIVE                                      0x0014 /* Error while trying to read the message queue */
#define RTDS_ERROR_NO_MORE_MSG_UNIQUE_ID                            0x0015 /* No more message unique id available. Increase RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE */

#define RTDS_ERROR_MALLOC_TIMER_STATE_IN_START_TIMER                0x0020 /* Cannot allocate memory in the function RTDS_StartTimer */
#define RTDS_ERROR_NO_MORE_TIMER_UNIQUE_ID                          0x0021 /* No more timer id */

#define RTDS_ERROR_PROCESS_CREATE_MALLOC                            0x0030 /* Cannot allocate memory in the function RTDS_ProcessCreate */
#define RTDS_ERROR_PROCESS_CREATE_MSG_Q_CREATE                      0x0031 /* Cannot create a message queue */
#define RTDS_ERROR_PROCESS_CREATE_TASK_SPAWN                        0x0032 /* Cannot create a task */
#define RTDS_ERROR_TASK_DELETE                                      0x0033 /* Cannot delete a task */
#define RTDS_ERROR_GET_PROCESS_QUEUE_ID                             0x0034 /* process name not found */
#define RTDS_ERROR_TASK_TO_DELETE_NOT_FOUND                         0x0035 /* The task to delete was not found in the globalProcessInfoList */

#define RTDS_ERROR_SEM_INFO_INSERT_MALLOC                           0x0040 /* Cannot allocate memory */
#define RTDS_ERROR_SEM_INFO_INSERT                                  0x0041 /* The semaphore to insert is null */
#define RTDS_ERROR_GET_SEMAPHORE_ID                                 0x0042 /* semaphore name not found */
#define RTDS_ERROR_GIVE_SEMAPHORE_ID                                0x0043 /* Cannot give a semaphore */
#define RTDS_ERROR_DELETE_SEMAPHORE_ID                              0x0044 /* Cannot delete a semaphore */
#define RTDS_ERROR_TAKE_SEMAPHORE_ID                                0x0045 /* Cannot take a semaphore */
#define RTDS_ERROR_FLUSH_SEMAPHORE_ID                               0x0046 /* Cannot flush a semaphore */
#define RTDS_ERROR_CREATE_MUTEX_SEMAPHORE                           0x0047 /* Cannot create a mutex semaphore */
#define RTDS_ERROR_CREATE_BINARY_SEMAPHORE                          0x0048 /* Cannot create a binary semaphore */

#define RTDS_ERROR_STARTUP_CONTEXT_MALLOC                           0x0050 /* startup task could not allocate memory for current context */

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_ERROR_H_ */

