#ifndef _RTDS_EXTERNAL_PROCEDURES_H_
#define _RTDS_EXTERNAL_PROCEDURES_H_

#include "RTDS_CommonTypes.h"
#include "RTDS_String.h"

/* Maximum number of files that can be opened */
#ifndef RTDS_MAX_FILES
#define RTDS_MAX_FILES 64
#endif


/* FUNCTION PragmaDev_FileOpen:
 * ----------------------------
 * Opens a file.
 * 
 * Parameters:
 * file_name: name of the file to be opened 
 * file_mode: mode to open file (e.g., read, write, ...)
 * 
 * Returns: unique file identifier 
 */
int PragmaDev_FileOpen(RTDS_String file_name, RTDS_String file_mode);

/* FUNCTION PragmaDev_FileClose:
 * -----------------------------
 * Closes a file.
 * 
 * file_id: unique file identifier
 * returns: TRUE if file was closed successfully 
 */
RTDS_BOOLEAN PragmaDev_FileClose(int file_id);

/* FUNCTION PragmaDev_FileReadLine:
 * --------------------------------
 * Reads a line of text from a file.
 * 
 * Parameters:
 * file_id: unique file identifier
 * string_to_read: string to put the read line
 * 
 * Returns: the read line 
 */
char * PragmaDev_FileReadLine(int file_id, char * string_to_read);

/* FUNCTION PragmaDev_FileWriteLine:
 * ---------------------------------
 * Writes a line of text to a file.
 * 
 * Parameters:
 * string_to_write: string to write in the file
 * file_id: unique file identifier
 * 
 * Returns: TRUE if the text was written successfully 
 */
RTDS_BOOLEAN PragmaDev_FileWriteLine(RTDS_String string_to_write, int file_id);

/* FUNCTION PragmaDev_RadarGraphCreate:
 * ------------------------------------
 * Not used.
 */
int PragmaDev_RadarGraphCreate(RTDS_String graph_name, RTDS_String branch_labels);

/* FUNCTION PragmaDev_RadarGraphAddLine:
 * -------------------------------------
 * Not used.
 */
RTDS_BOOLEAN PragmaDev_RadarGraphAddLine(int graph_id, RTDS_String line_label, RTDS_String line_branch_values);

/* FUNCTION PragmaDev_b4sprintf:
 * -----------------------------
 * Convert a bool to a parameter for PragmaDev_sprintf.
 * 
 * Parameters:
 * boolean_arg: the bool to convert
 * return_value: converted value
 * 
 * Returns: converted value
 */
PragmaDev_arg4sprintf * PragmaDev_b4sprintf(RTDS_BOOLEAN boolean_arg, PragmaDev_arg4sprintf * return_value);

/* FUNCTION PragmaDev_i4sprintf:
 * -----------------------------
 * Convert an int to a parameter for PragmaDev_sprintf.
 * 
 * Parameters:
 * integer_arg: the int to convert
 * return_value: converted value
 * 
 * Returns: converted value
 */
PragmaDev_arg4sprintf * PragmaDev_i4sprintf(int integer_arg, PragmaDev_arg4sprintf * return_value);

/* FUNCTION PragmaDev_f4sprintf:
 * -----------------------------
 * Convert a float to a parameter for PragmaDev_sprintf.
 * 
 * Parameters:
 * float_arg: the float to convert
 * return_value: converted value
 * 
 * Returns: converted value
 */
PragmaDev_arg4sprintf * PragmaDev_f4sprintf(float float_arg, PragmaDev_arg4sprintf * return_value);

/* FUNCTION PragmaDev_s4sprintf:
 * -----------------------------
 * Convert a string to a parameter for PragmaDev_sprintf.
 * 
 * Parameters:
 * charstring_arg: the string to convert
 * return_value: converted value
 * 
 * Returns: converted value
 */
PragmaDev_arg4sprintf * PragmaDev_s4sprintf(char * charstring_arg, PragmaDev_arg4sprintf * return_value);

/* FUNCTION PragmaDev_sprintf:
 * ---------------------------
 * C sprintf like function.
 * 
 * Parameters:
 * format: format string (with specifiers)
 * return_value: arguments to replace specifiers
 * 
 * Returns: formatted string
 */
char * PragmaDev_sprintf(char * format, PragmaDev_arg4sprintf * args, char * return_value);

#endif
